"use strict";

// use this for events only

$(document).ready(function () {
    $('#available-slots').hide();
    $('.rescheduled_date').hide();
    $('#status').change(function (e) {
        e.preventDefault();
        var status = $('#status').val();
        if (status === 'rescheduled') {
            $('#available-slots').show();
            $('.rescheduled_date').show();
        } else {
            $('#available-slots').hide();
            $('.rescheduled_date').hide();
        }
    });

    $('#rescheduled_date').change(function (e) {
        $('#available-slots').empty();
        var weekday = new Array(7);
        e.preventDefault();
        var date = $('#rescheduled_date').val()
        var d = new Date(date)
        var id = $('#order_id').val();
        var input_body = {
            [csrfName]: csrfHash,
            'id': id,
            'date': date
        };
        $.ajax({
            type: "POST",
            url: baseUrl + "/partner/orders/get_slots",
            data: input_body,
            dataType: "JSON",
            success: function (response) {
                if (response.error == false) {
                    var slots = response.available_slots;
                    var slot_selector = "";
                    slots.forEach(element => {
                        slot_selector +=
                            `   <div class="col-md-2 form-group">
                                    <div class="selectgroup">
                                        <label class="selectgroup-item">
                                        <input type="radio" name="reschedule" value="` + element + `" class="selectgroup-input">
                                            <span class="selectgroup-button selectgroup-button-icon">
                                                <i class="fas fa-sun"></i> &nbsp; ` + element + `
                                            </span>
                                        </label>                                    
                                    </div>
                                </div>
                                 `;
                    });

                    $('#available-slots').append(slot_selector);
                } else {
                    setTimeout(() => {
                        $('#ordered_services_list').bootstrapTable('refresh')
                    }, 2000);
                }
            }
        });

    });

    $('#change_status').on('click', function (e) {
        e.preventDefault();

        // var rc_time = $('.selectgroup-input');
        var status = $('#status').val();
        var date = $('#rescheduled_date').val()
        var selected_time = '';
        var id = $('#order_id').val();
        console.log(status);
        if ($('.selectgroup-input').length > 1) {
            selected_time = $('input[name="reschedule"]:checked').val();
        }
        var input_body = {
            [csrfName]: csrfHash,
            'order_id': id,
            'date': date,
            'status': status,
            'selected_time': selected_time,
        };
        // console.log(input_body);
        // return;
        $.ajax({
            type: "POST",
            url: baseUrl + "/partner/orders/update_order_status",
            data: input_body,
            dataType: "json",
            success: function (response) {
                console.log(response);
                if (response.error == false) {
                    showToastMessage("Order Status Updated", "success");
                    window.location.reload();
                } else {
                    showToastMessage(response.message, "error");
                    window.location.reload();
                }
            }
        });
    });
});

window.order_service_event = {
    'click .cancel_service': function (e, value, row, index) {
        console.log(row);
    }
}